﻿using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;
using Ext.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;

public class CUserCalendar
{
     private BaseMaster m_BaseMstr
    { set; get; }

    public CUserCalendar(BaseMaster BaseMstr)
    {
        m_BaseMstr = BaseMstr;
    }

    public DataSet GetAllEventsDS()
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList();

        //add params for the DB stored procedure call
        //plist.AddInputParameter("pi_nMID", lMID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_USER_CALENDAR.GetAllEventsRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }

    }

    public DataSet GetAllCalendarsDS()
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList();

        //add params for the DB stored procedure call
        //plist.AddInputParameter("pi_nMID", lMID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_USER_CALENDAR.GetAllCalendarsRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }

    }

    //public EventModelCollection GetEventCollection(DataSet ds) {
    //    EventModelCollection emc = new EventModelCollection();
    //    List<EventModel> list = new List<EventModel>();
    //    if(ds != null){
    //        foreach (DataTable dt in ds.Tables) { 
    //            foreach(DataRow dr in dt.Rows){
    //                var evt = new EventModel();

    //                //set event object properties

    //                //calendar_id
    //                if(!dr.IsNull("calendar_id")){
    //                    evt.CalendarId = Convert.ToInt32(dr["calendar_id"]);
    //                }

    //                //end_date
    //                if (!dr.IsNull("end_date"))
    //                {
    //                    evt.EndDate = Convert.ToDateTime(dr["end_date"]);
    //                }

    //                //event_id
    //                if (!dr.IsNull("event_id"))
    //                {
    //                    evt.EventId = Convert.ToInt32(dr["event_id"]);
    //                }

    //                //is_all_day
    //                if (!dr.IsNull("is_all_day"))
    //                {
    //                    evt.IsAllDay = Convert.ToBoolean(dr["is_all_day"]);
    //                }

    //                //location
    //                if (!dr.IsNull("location"))
    //                {
    //                    evt.Location = dr["location"].ToString();
    //                }

    //                //notes
    //                if (!dr.IsNull("notes"))
    //                {
    //                    evt.Notes = dr["notes"].ToString();
    //                }

    //                //reminder
    //                if (!dr.IsNull("reminder"))
    //                {
    //                    evt.Reminder = dr["reminder"].ToString();
    //                }

    //                //start_date
    //                if (!dr.IsNull("start_date"))
    //                {
    //                    evt.StartDate = Convert.ToDateTime(dr["start_date"]);
    //                }

    //                //title
    //                if (!dr.IsNull("title"))
    //                {
    //                    evt.Title = dr["title"].ToString();
    //                }

    //                //url
    //                if(!dr.IsNull("url")){
    //                    evt.Url = dr["url"].ToString();
    //                }

    //                list.Add(evt);
    //            }
    //        }
    //        emc.InsertRange(0, list);
    //    }
    //    return emc;
    //}

    public EventModelCollection GetEventCollection(DataSet ds)
    {
        EventModelCollection emc = new EventModelCollection();
        List<EventModel> list = new List<EventModel>();
        if (ds != null)
        {
            foreach (DataTable dt in ds.Tables)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    var evt = new EventModel();

                    //set event object properties

                    //calendar_id
                    evt.CalendarId = 1;

                    //end_date
                    if (!dr.IsNull("DATE_SCHEDULED"))
                    {
                        evt.EndDate = Convert.ToDateTime(dr["DATE_SCHEDULED"]);
                    }

                    //event_id
                    if (!dr.IsNull("PAT_PW_EVENT_ID"))
                    {
                        evt.EventId = Convert.ToInt32(dr["PAT_PW_EVENT_ID"]);
                    }

                    //is_all_day
                    evt.IsAllDay = true;

                    //location
                    //if (!dr.IsNull("location"))
                    //{
                    //    evt.Location = dr["location"].ToString();
                    //}

                    //notes
                    //if (!dr.IsNull("notes"))
                    //{
                    //    evt.Notes = dr["notes"].ToString();
                    //}

                    //reminder
                    //if (!dr.IsNull("reminder"))
                    //{
                    //    evt.Reminder = dr["reminder"].ToString();
                    //}

                    //start_date
                    if (!dr.IsNull("DATE_SCHEDULED"))
                    {
                        evt.StartDate = Convert.ToDateTime(dr["DATE_SCHEDULED"]);
                    }

                    //title
                    if (!dr.IsNull("EVENT_TITLE"))
                    {
                        string strEventTitle = Regex.Replace(dr["EVENT_TITLE"].ToString(), ".*\\((.+)\\).*", "$1");
                        evt.Title = strEventTitle;
                    }

                    //url
                    //if (!dr.IsNull("url"))
                    //{
                    //    evt.Url = dr["url"].ToString();
                    //}

                    list.Add(evt);
                }
            }
            emc.InsertRange(0, list);
        }
        return emc;
    }


    public bool UpdateEvent(long lEventID,
                            string strTitle,
                            string strStartDate,
                            string strEndDate,
                            long lCalendarId,
                            string strLocation,
                            string strNotes,
                            string strReminder,
                            string strUrl,
                            long lAllDay)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList();

        /*
            pi_nEventID    in number,
            pi_nCalendarID in number,
            pi_vTitle      in varchar2,
            pi_vStartDate  in varchar2,
            pi_vEndDate    in varchar2,
            pi_vLocation   in varchar2,
            pi_vNotes      in varchar2,
            pi_vReminder   in varchar2,
            pi_vUrl        in varchar2,
            pi_nAllDay     in number,
        */

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_nEventID", lEventID);
        plist.AddInputParameter("pi_vTitle", strTitle);
        plist.AddInputParameter("pi_vStartDate", strStartDate);
        plist.AddInputParameter("pi_vEndDate", strEndDate);

        plist.AddInputParameter("pi_nCalendarID", lCalendarId);
        plist.AddInputParameter("pi_vLocation", strLocation);
        plist.AddInputParameter("pi_vNotes", strNotes);
        plist.AddInputParameter("pi_vReminder", strReminder);
        plist.AddInputParameter("pi_vUrl", strUrl);
        plist.AddInputParameter("pi_nAllDay", lAllDay);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_USER_CALENDAR.UpdateEvent",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        if(lStatusCode == 0){
            return true;
        }
        return false;
    }

    public bool InsertEvent(string strTitle,
                            string strStartDate,
                            string strEndDate,
                            long lCalendarId,
                            string strLocation,
                            string strNotes,
                            string strReminder,
                            string strUrl,
                            long lAllDay)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList();

        /*
            pi_nEventID    in number,
            pi_nCalendarID in number,
            pi_vTitle      in varchar2,
            pi_vStartDate  in varchar2,
            pi_vEndDate    in varchar2,
            pi_vLocation   in varchar2,
            pi_vNotes      in varchar2,
            pi_vReminder   in varchar2,
            pi_vUrl        in varchar2,
            pi_nAllDay     in number,
        */

        //add params for the DB stored procedure call
        //plist.AddInputParameter("pi_nEventID", lEventID);
        plist.AddInputParameter("pi_vTitle", strTitle);
        plist.AddInputParameter("pi_vStartDate", strStartDate);
        plist.AddInputParameter("pi_vEndDate", strEndDate);

        plist.AddInputParameter("pi_nCalendarID", lCalendarId);
        plist.AddInputParameter("pi_vLocation", strLocation);
        plist.AddInputParameter("pi_vNotes", strNotes);
        plist.AddInputParameter("pi_vReminder", strReminder);
        plist.AddInputParameter("pi_vUrl", strUrl);
        plist.AddInputParameter("pi_nAllDay", lAllDay);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_USER_CALENDAR.InsertEvent",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;
        }
        return false;
    }


}